# MedSchedule Pro

Um aplicativo web inovador para controle de horários e frequência de medicamentos, com funcionalidade offline, alarmes inteligentes e integração com Google Calendar.

## Características Principais

### 📋 Gerenciamento de Medicamentos
- **Cadastro Intuitivo**: Adicione medicamentos com nome, dosagem, frequência e horários
- **Cores Personalizadas**: Cada medicamento pode ter uma cor única para fácil identificação
- **Agendamento Flexível**: Configure horários específicos ou padrões recorrentes
- **Período Determinado**: Defina datas de início e término para medicamentos temporários

### 📅 Visualizações Inteligentes
- **Visão Diária**: Lista de medicamentos do dia com status de ingestão
- **Visão Semanal**: Grid visual mostrando toda a semana de medicamentos
- **Taxa de Aderência**: Acompanhe sua aderência ao tratamento em tempo real
- **Histórico Completo**: Registre quando cada medicamento foi tomado

### 🔔 Sistema de Notificações Avançado
- **Notificações do Navegador**: Alertas visuais quando chegar a hora do medicamento
- **Som Customizável**: Alarme sonoro com padrão específico para medicamentos
- **Vibração**: Suporte a vibração em dispositivos móveis
- **Lembretes Antecipados**: Configure notificações 5, 10, 15 ou 30 minutos antes

### 📱 Funcionalidade Offline
- **Service Worker**: Aplicativo funciona completamente offline
- **Sincronização Automática**: Dados sincronizam quando a conexão retorna
- **Cache Inteligente**: Páginas e assets são armazenados em cache local
- **IndexedDB**: Banco de dados local para dados de medicamentos

### 🔐 Segurança e Privacidade
- **Autenticação Manus OAuth**: Login seguro com sua conta Manus
- **Dados Criptografados**: Todos os dados são transmitidos com HTTPS
- **Sem Rastreamento**: Seus dados de saúde são privados e seguros
- **Usuário Único**: Cada usuário tem acesso apenas aos seus dados

### 🌐 Integração Google Calendar (Preparado)
- **Sincronização Bidirecional**: Medicamentos aparecem no seu Google Calendar
- **Lembretes Integrados**: Receba notificações do Google Calendar também
- **Visualização Unificada**: Veja medicamentos junto com outros compromissos
- **Estrutura Pronta**: Backend preparado para integração (requer credenciais OAuth)

## Arquitetura Técnica

### Stack Tecnológico
- **Frontend**: React 19 + TypeScript + Tailwind CSS 4
- **Backend**: Express 4 + tRPC 11
- **Banco de Dados**: MySQL/TiDB com Drizzle ORM
- **Autenticação**: Manus OAuth
- **Offline**: Service Worker + IndexedDB

### Estrutura de Dados

#### Medicamentos
```
- id: Identificador único
- userId: Usuário proprietário
- name: Nome do medicamento
- dosage: Dosagem (ex: 500mg)
- frequency: Vezes por dia
- startDate: Data de início
- endDate: Data de término (opcional)
- color: Cor para UI
- notes: Notas adicionais
```

#### Horários
```
- id: Identificador único
- medicationId: Medicamento relacionado
- hour: Hora (0-23)
- minute: Minuto (0-59)
- dayOfWeek: Dia da semana (0-6, opcional)
```

#### Registros de Ingestão
```
- id: Identificador único
- medicationId: Medicamento
- userId: Usuário
- scheduledTime: Horário agendado
- takenTime: Horário em que foi tomado
- notes: Notas sobre a ingestão
```

## Como Usar

### 1. Adicionar um Medicamento
1. Clique em "Adicionar Medicamento"
2. Preencha o nome, dosagem (opcional) e frequência
3. Defina as datas de início e término
4. Configure os horários específicos
5. Escolha uma cor para identificação
6. Clique em "Adicionar Medicamento"

### 2. Marcar Medicamento como Tomado
1. Na página inicial, você verá a lista de medicamentos do dia
2. Clique em "Marcar como tomado" para cada medicamento ingerido
3. O status mudará para verde com um checkmark
4. O histórico será registrado automaticamente

### 3. Visualizar Semana
1. Clique em "Visão Semanal" na página inicial
2. Veja todos os medicamentos de cada dia da semana
3. Acompanhe sua taxa de aderência
4. Navegue entre semanas com os botões de navegação

### 4. Configurar Alarmes
1. Clique no ícone de configurações (engrenagem)
2. Ative/desative alarmes, som e vibração
3. Configure quando deseja ser notificado
4. Clique em "Testar Alarme" para ouvir como será

### 5. Integrar com Google Calendar
1. Clique em Configurações > Google Calendar
2. Clique em "Conectar Google Calendar"
3. Autorize a aplicação com sua conta Google
4. Seus medicamentos aparecerão automaticamente no calendário

## Recursos Inovadores

### 📊 Taxa de Aderência
A visão semanal mostra sua taxa de aderência em tempo real, ajudando você a acompanhar se está seguindo corretamente o tratamento. Essa métrica é importante para médicos e farmacêuticos.

### 🎨 Código de Cores
Cada medicamento tem uma cor única, facilitando a identificação rápida visual, especialmente importante para quem toma vários medicamentos.

### 🔊 Alarmes Progressivos
O sistema de alarmes usa som e vibração progressivos para garantir que você não perca a hora de tomar o medicamento, mesmo em ambientes barulhentos.

### 📱 Funciona Offline
Diferente de muitos aplicativos, MedSchedule Pro funciona completamente offline. Você pode adicionar medicamentos, marcar como tomado e receber alarmes mesmo sem internet.

## Configuração (Para Desenvolvedores)

### Variáveis de Ambiente Necessárias
```
DATABASE_URL=mysql://user:password@host/database
JWT_SECRET=seu_secret_aqui
VITE_APP_ID=seu_app_id
OAUTH_SERVER_URL=https://api.manus.im
VITE_OAUTH_PORTAL_URL=https://portal.manus.im
```

### Para Integração com Google Calendar
```
GOOGLE_OAUTH_CLIENT_ID=seu_client_id
GOOGLE_OAUTH_CLIENT_SECRET=seu_client_secret
GOOGLE_OAUTH_REDIRECT_URI=https://seu-dominio.com/api/google-callback
```

### Instalação
```bash
pnpm install
pnpm db:push
pnpm dev
```

## Roadmap Futuro

- [ ] Integração completa com Google Calendar
- [ ] Sugestão automática de horários baseada em padrões
- [ ] Alertas para medicamentos vencidos
- [ ] Compartilhamento com cuidadores
- [ ] Relatórios de aderência em PDF
- [ ] Integração com wearables
- [ ] Modo escuro
- [ ] Múltiplos idiomas

## Suporte

Para problemas ou sugestões, entre em contato através da página de configurações do aplicativo.

## Licença

MedSchedule Pro © 2025. Todos os direitos reservados.

---

**Desenvolvido com ❤️ para ajudar você a nunca esquecer seus medicamentos.**
