# Guia de Testes - MedSchedule Pro

## Testes Manuais

### 1. Autenticação
- [ ] Acesse a página inicial sem estar autenticado
- [ ] Clique em "Entrar com Manus"
- [ ] Faça login com sua conta Manus
- [ ] Verifique se você é redirecionado para a página principal
- [ ] Clique no ícone de configurações e depois em "Sair da Conta"
- [ ] Verifique se você é desconectado

### 2. Adicionar Medicamentos
- [ ] Clique em "Adicionar Medicamento"
- [ ] Preencha os campos obrigatórios (nome, frequência)
- [ ] Teste com diferentes combinações de horários
- [ ] Adicione um medicamento com data de término
- [ ] Adicione um medicamento contínuo (sem data de término)
- [ ] Verifique se o medicamento aparece na lista lateral

### 3. Visão Diária
- [ ] Navegue para diferentes datas usando o seletor de data
- [ ] Verifique se os medicamentos corretos aparecem para cada dia
- [ ] Clique em "Hoje" para voltar ao dia atual
- [ ] Teste marcar medicamentos como tomados
- [ ] Verifique se o status muda para verde com checkmark

### 4. Visão Semanal
- [ ] Clique em "Visão Semanal"
- [ ] Verifique se todos os 7 dias aparecem
- [ ] Navegue para a semana anterior e próxima
- [ ] Clique em "Hoje" para voltar à semana atual
- [ ] Verifique se a taxa de aderência é calculada corretamente
- [ ] Teste marcar medicamentos como tomados na visão semanal

### 5. Configurações de Alarmes
- [ ] Acesse Configurações
- [ ] Ative/desative alarmes
- [ ] Ative/desative som
- [ ] Ative/desative vibração
- [ ] Altere o tempo de notificação antecipada
- [ ] Clique em "Testar Alarme" e verifique se você ouve o som
- [ ] Verifique se as configurações são salvas ao recarregar a página

### 6. Funcionalidade Offline
- [ ] Abra o DevTools (F12)
- [ ] Vá para a aba "Application" > "Service Workers"
- [ ] Verifique se o Service Worker está registrado
- [ ] Vá para "Network" e marque "Offline"
- [ ] Recarregue a página
- [ ] Verifique se a página ainda carrega
- [ ] Tente adicionar um novo medicamento offline
- [ ] Desmarque "Offline"
- [ ] Verifique se os dados são sincronizados

### 7. Google Calendar (Preparado)
- [ ] Acesse Configurações > Google Calendar
- [ ] Verifique se a página de integração carrega
- [ ] Clique em "Abrir Google Calendar" para verificar o link
- [ ] Nota: A integração completa requer credenciais OAuth do Google

### 8. Responsividade
- [ ] Teste em desktop (1920x1080)
- [ ] Teste em tablet (768x1024)
- [ ] Teste em mobile (375x667)
- [ ] Verifique se todos os elementos são visíveis
- [ ] Teste navegação em todos os tamanhos

### 9. Dados e Persistência
- [ ] Adicione vários medicamentos
- [ ] Recarregue a página
- [ ] Verifique se todos os medicamentos ainda estão lá
- [ ] Marque alguns como tomados
- [ ] Recarregue a página
- [ ] Verifique se o status de "tomado" foi mantido
- [ ] Navegue para diferentes datas e volte
- [ ] Verifique se os dados são consistentes

### 10. Casos Extremos
- [ ] Adicione um medicamento com nome muito longo
- [ ] Adicione um medicamento com caracteres especiais
- [ ] Tente adicionar medicamento sem nome (deve falhar)
- [ ] Tente adicionar medicamento com frequência 0 (deve falhar)
- [ ] Adicione múltiplos horários para um medicamento
- [ ] Teste com data de término anterior à data de início

## Testes de Performance

### 1. Carregamento
- [ ] Meça o tempo de carregamento inicial
- [ ] Verifique se o aplicativo carrega em menos de 3 segundos
- [ ] Teste em conexão 3G (DevTools > Network > Throttling)

### 2. Responsividade
- [ ] Teste a velocidade de adição de medicamentos
- [ ] Teste a velocidade de marcação de medicamentos como tomados
- [ ] Teste a navegação entre páginas
- [ ] Verifique se não há lag ao interagir com a UI

## Testes de Acessibilidade

- [ ] Teste navegação com teclado (Tab, Enter, Escape)
- [ ] Verifique se todos os botões têm labels
- [ ] Teste com leitor de tela (NVDA ou JAWS)
- [ ] Verifique contraste de cores (WCAG AA)
- [ ] Teste com zoom de página em 200%

## Testes de Segurança

- [ ] Verifique se a autenticação é obrigatória
- [ ] Tente acessar dados de outro usuário (deve falhar)
- [ ] Verifique se as senhas não são armazenadas localmente
- [ ] Teste CSRF (Cross-Site Request Forgery)
- [ ] Verifique se as APIs requerem autenticação

## Checklist de Lançamento

- [ ] Todos os testes manuais passam
- [ ] Sem erros no console
- [ ] Sem warnings no console
- [ ] Performance aceitável
- [ ] Acessibilidade OK
- [ ] Segurança validada
- [ ] README atualizado
- [ ] Documentação completa
- [ ] Checkpoint criado

## Relatório de Bugs

Se encontrar algum bug durante os testes, por favor documente:

1. **Título**: Descrição breve do problema
2. **Passos para Reproduzir**: Como reproduzir o bug
3. **Resultado Esperado**: O que deveria acontecer
4. **Resultado Atual**: O que realmente acontece
5. **Screenshots**: Se aplicável
6. **Ambiente**: Navegador, SO, versão do app

Exemplo:
```
Título: Medicamento não aparece após adicionar
Passos: 1. Clique em "Adicionar Medicamento"
        2. Preencha os campos
        3. Clique em "Adicionar Medicamento"
Esperado: Medicamento aparece na lista
Atual: Medicamento não aparece na lista
Navegador: Chrome 120.0
SO: Windows 11
```
